/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart.scheduler.sources;

import br.com.minecart.Main;
import br.com.minecart.MinecartHttpResponseTranslateMessage;
import br.com.minecart.config.MinecartConfig;
import br.com.minecart.core.MinecartAPI;
import br.com.minecart.core.entities.Key;
import br.com.minecart.core.utilities.http.HttpRequestException;
import br.com.minecart.helpers.MinecartKeyHelper;
import br.com.minecart.scheduler.SchedulerInterface;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.console.ConsoleSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AutomaticDelivery
implements SchedulerInterface {
    public static final int DELAY = 60;
    public static final int NONE = 0;
    public static final int ONLY_PLAYER_ONLINE = 1;
    public static final int ANYTIME = 2;

    @Override
    public void run() {
        try {
            ArrayList<Key> keys = MinecartKeyHelper.filterByAutomaticDelivery(MinecartAPI.deliveryPending());
            if (keys.isEmpty()) {
                return;
            }
            MinecartAPI.deliveryConfirm(MinecartKeyHelper.getMinecartKeyIds(keys));
            ArrayList<String> commands = new ArrayList<String>();
            for (Key key : keys) {
                Collections.addAll(commands, key.getCommands());
            }
            this.executeCommands(commands);
        }
        catch (HttpRequestException e) {
            Message message = MinecartHttpResponseTranslateMessage.messageHttpError((CommandSender)ConsoleSender.INSTANCE, e.getResponse());
            ConsoleSender.INSTANCE.sendMessage(message);
        }
    }

    private void executeCommands(List<String> commands) {
        long delay = 0L;
        for (String command : commands) {
            HytaleServer.SCHEDULED_EXECUTOR.schedule(() -> CommandManager.get().handleCommand((CommandSender)ConsoleSender.INSTANCE, command), delay, TimeUnit.MILLISECONDS);
            delay += ((MinecartConfig)Main.CONFIG.get()).getDelayExecuteCommands() * 1L;
        }
    }
}

