/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PlayerSessionManager {
    private static final PlayerSessionManager INSTANCE = new PlayerSessionManager();
    private final Map<String, Long> playerJoinTimestamps = new ConcurrentHashMap<String, Long>();

    private PlayerSessionManager() {
    }

    public static PlayerSessionManager getInstance() {
        return INSTANCE;
    }

    public void onJoin(String username) {
        this.playerJoinTimestamps.put(this.normalize(username), System.currentTimeMillis());
    }

    public void onQuit(String username) {
        this.playerJoinTimestamps.remove(this.normalize(username));
    }

    public boolean exists(String username) {
        return this.playerJoinTimestamps.containsKey(this.normalize(username));
    }

    public Long getJoinTime(String username) {
        return this.playerJoinTimestamps.get(this.normalize(username));
    }

    public Long getSessionDuration(String username) {
        Long joinedAt = this.playerJoinTimestamps.get(this.normalize(username));
        if (joinedAt == null) {
            return 0L;
        }
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - joinedAt);
    }

    public boolean isInCooldown(String username, long delayMs) {
        Long joinedAt = this.playerJoinTimestamps.get(this.normalize(username));
        if (joinedAt == null) {
            return false;
        }
        return System.currentTimeMillis() - joinedAt < delayMs;
    }

    public void clear() {
        this.playerJoinTimestamps.clear();
    }

    private String normalize(String username) {
        return username.toLowerCase();
    }
}

