/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart.core;

import br.com.minecart.core.entities.Cash;
import br.com.minecart.core.entities.Key;
import br.com.minecart.core.utilities.Utils;
import br.com.minecart.core.utilities.http.HttpRequest;
import br.com.minecart.core.utilities.http.HttpRequestException;
import br.com.minecart.core.utilities.http.HttpResponse;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class MinecartAPI {
    private static final String URL = "https://api.minecart.com.br";
    public static final int INVALID_KEY = 40010;
    public static final int INVALID_SHOP_SERVER = 40011;
    public static final int DONT_HAVE_CASH = 40012;
    public static final int COMMANDS_NOT_REGISTRED = 40013;

    public static ArrayList<Key> myKeys(String username) throws Exception {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("username", username);
        HttpResponse response = HttpRequest.httpRequest("https://api.minecart.com.br/shop/player/mykeys", params);
        if (response.responseCode != 200) {
            throw new HttpRequestException(response);
        }
        JsonObject jsonObject = JsonParser.parseString((String)response.response).getAsJsonObject();
        JsonArray productsPlayer = jsonObject.getAsJsonArray("products");
        ArrayList<Key> keys = new ArrayList<Key>();
        for (JsonElement product : productsPlayer) {
            JsonObject productObj = product.getAsJsonObject();
            Integer id = productObj.get("id").getAsInt();
            String key = productObj.get("key").getAsString();
            String productName = productObj.get("product_name").getAsString();
            keys.add(new Key(id, productName, username, key, null, 0));
        }
        return keys;
    }

    public static Cash redeemCash(String username) throws HttpRequestException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("username", username);
        HttpResponse response = HttpRequest.httpRequest("https://api.minecart.com.br/shop/player/redeemcash", params);
        if (response.responseCode != 200) {
            throw new HttpRequestException(response);
        }
        JsonObject jsonObject = JsonParser.parseString((String)response.response).getAsJsonObject();
        int quantity = jsonObject.get("cash").getAsInt();
        String command = jsonObject.get("command").getAsString();
        return new Cash(quantity, command);
    }

    public static Key redeemKey(String username, String key) throws HttpRequestException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("username", username);
        params.put("key", key);
        HttpResponse response = HttpRequest.httpRequest("https://api.minecart.com.br/shop/player/redeemkey", params);
        if (response.responseCode != 200) {
            throw new HttpRequestException(response);
        }
        JsonObject productObj = JsonParser.parseString((String)response.response).getAsJsonObject();
        Integer id = productObj.get("id").getAsInt();
        String productName = productObj.get("product_name").getAsString();
        String[] commands = Utils.convertJsonArrayToStringArray(productObj.get("commands").getAsJsonArray());
        return new Key(id, productName, username, key, commands, 0);
    }

    public static ArrayList<Key> deliveryPending() throws HttpRequestException {
        ArrayList<Key> keys = new ArrayList<Key>();
        HttpResponse response = HttpRequest.httpRequest("https://api.minecart.com.br/shop/delivery/pending", null);
        if (response.responseCode != 200) {
            throw new HttpRequestException(response);
        }
        JsonObject jsonObject = JsonParser.parseString((String)response.response).getAsJsonObject();
        JsonArray productsPlayer = jsonObject.getAsJsonArray("products");
        for (JsonElement product : productsPlayer) {
            JsonObject productObj = product.getAsJsonObject();
            Integer id = productObj.get("id").getAsInt();
            String username = productObj.get("username").getAsString();
            String productName = productObj.get("product_name").getAsString();
            String key = productObj.get("key").getAsString();
            String[] commands = Utils.convertJsonArrayToStringArray(productObj.get("commands").getAsJsonArray());
            int deliveryAutomatic = productObj.get("delivery_automatic").getAsInt();
            keys.add(new Key(id, productName, username, key, commands, deliveryAutomatic));
        }
        return keys;
    }

    public static boolean deliveryConfirm(int[] ids) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < ids.length) {
            params.put("products[" + i + "]", String.valueOf(ids[i]));
            ++i;
        }
        try {
            HttpResponse response = HttpRequest.httpRequest("https://api.minecart.com.br/shop/delivery/confirm", params);
            return response.responseCode == 200;
        }
        catch (HttpRequestException httpRequestException) {
            return false;
        }
    }
}

