/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart.commands;

import br.com.minecart.MinecartHttpResponseTranslateMessage;
import br.com.minecart.commands.CommandMessages;
import br.com.minecart.core.MinecartAPI;
import br.com.minecart.core.entities.Cash;
import br.com.minecart.core.utilities.http.HttpRequestException;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandManager;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.console.ConsoleSender;
import com.hypixel.hytale.server.core.entity.entities.Player;
import java.util.concurrent.CompletableFuture;

public class RedeemCashCommand
extends AbstractAsyncCommand {
    public RedeemCashCommand() {
        super("redeemcash", "Redeems available cash");
        this.addAliases(new String[]{"resgatarcash"});
    }

    protected CompletableFuture<Void> executeAsync(CommandContext commandContext) {
        CommandSender sender = commandContext.sender();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return CompletableFuture.runAsync(() -> {
                try {
                    Cash minecartCash = MinecartAPI.redeemCash(player.getDisplayName());
                    if (minecartCash.getQuantity() > 0) {
                        this.delivery(player, minecartCash);
                    }
                }
                catch (HttpRequestException e) {
                    MinecartHttpResponseTranslateMessage.processHttpError(player, e.getResponse());
                }
            });
        }
        commandContext.sendMessage(CommandMessages.PLAYER_ONLY);
        return CompletableFuture.completedFuture(null);
    }

    private boolean delivery(Player player, Cash minecartCash) {
        String command = minecartCash.getCommand();
        CommandManager.get().handleCommand((CommandSender)ConsoleSender.INSTANCE, command);
        player.sendMessage(this.parseText(CommandMessages.SUCCESS_REDEEM_CASH, player));
        return true;
    }

    private Message parseText(Message message, Player player) {
        return message.param("player.name", player.getDisplayName());
    }
}

