/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart;

import br.com.minecart.commands.CommandMessages;
import br.com.minecart.core.utilities.http.HttpResponse;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.entity.entities.Player;

public class MinecartHttpResponseTranslateMessage {
    public static void processHttpError(Player player, HttpResponse response) {
        Message message = MinecartHttpResponseTranslateMessage.messageHttpError((CommandSender)player, response);
        if (response.responseCode == 401 && !player.hasPermission("minecart.admin")) {
            message = CommandMessages.INTERNAL_SERVER_ERROR;
        }
        player.sendMessage(message);
    }

    public static Message messageHttpError(CommandSender player, HttpResponse response) {
        if (response.responseCode == 401) {
            return CommandMessages.ERROR_INVALID_SHOPKEY;
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response.response).getAsJsonObject();
            Integer errorCode = jsonObject.get("code").getAsInt();
            switch (errorCode) {
                case 40010: {
                    return CommandMessages.ERROR_INVALID_KEY;
                }
                case 40011: {
                    return player.hasPermission("minecart.admin") ? CommandMessages.ERROR_INVALID_SHOPSERVER : CommandMessages.INTERNAL_SERVER_ERROR;
                }
                case 40012: {
                    return CommandMessages.ERROR_DONT_HAVE_CASH;
                }
                case 40013: {
                    return CommandMessages.ERROR_COMMANDS_NOT_REGISTRED;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CommandMessages.INTERNAL_SERVER_ERROR;
    }
}

