/*
 * Decompiled with CFR 0.152.
 */
package br.com.minecart;

import br.com.minecart.commands.MinecartCommand;
import br.com.minecart.commands.MyKeysCommand;
import br.com.minecart.commands.RedeemCashCommand;
import br.com.minecart.commands.RedeemKeyCommand;
import br.com.minecart.config.MinecartConfig;
import br.com.minecart.core.CommandFailureLogger;
import br.com.minecart.core.config.MinecartCoreConfig;
import br.com.minecart.listeners.PlayerConnectListener;
import br.com.minecart.listeners.PlayerDisconnectListener;
import br.com.minecart.scheduler.sources.AutomaticDelivery;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerDisconnectEvent;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.util.Config;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class Main
extends JavaPlugin {
    public static final String VERSION = "3.0.2";
    public static Config<MinecartConfig> CONFIG;

    public Main(JavaPluginInit init) {
        super(init);
        CONFIG = this.withConfig("Minecart", MinecartConfig.CODEC);
    }

    protected void setup() {
        super.setup();
        CONFIG.save();
        MinecartCoreConfig.configure(VERSION, "Hytale", ((MinecartConfig)CONFIG.get()).getShopKey(), ((MinecartConfig)CONFIG.get()).getShopServer());
        CommandFailureLogger.setLogPath(this.getDataDirectory().toString());
        this.getCommandRegistry().registerCommand((AbstractCommand)new MinecartCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new MyKeysCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new RedeemKeyCommand());
        this.getCommandRegistry().registerCommand((AbstractCommand)new RedeemCashCommand());
        this.getEventRegistry().registerGlobal(PlayerConnectEvent.class, (Consumer)new PlayerConnectListener());
        this.getEventRegistry().registerGlobal(PlayerDisconnectEvent.class, (Consumer)new PlayerDisconnectListener());
        HytaleServer.SCHEDULED_EXECUTOR.scheduleWithFixedDelay(() -> new AutomaticDelivery().run(), 60L, 60L, TimeUnit.SECONDS);
    }
}

